// SetupDialog.cpp : implementation file
//

#include "stdafx.h"
#include "SC500.h"
#include "SC500Dlg.h"
#include "SetupDialog.h"
#include "PropertyDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSetupDialog dialog

CSetupDialog::CSetupDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CSetupDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetupDialog)
	//}}AFX_DATA_INIT
}


void CSetupDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetupDialog)
	DDX_Control(pDX, IDC_EDIT_CHANNEL_CH02, m_editChannel02);
	DDX_Control(pDX, IDC_EDIT_CHANNEL_CH04, m_editChannel04);
	DDX_Control(pDX, IDC_EDIT_CHANNEL_CH03, m_editChannel03);
	DDX_Control(pDX, IDC_EDIT_CHANNEL_CH01, m_editChannel01);
	DDX_Control(pDX, IDC_PROGRESS_EXPORT, m_progressExport);
	DDX_Control(pDX, IDC_STATIC_EXPORT_PATH, m_staticExportPath);
	DDX_Control(pDX, IDC_STATIC_RECORD_PATH, m_staticRecordPath);
	DDX_Control(pDX, IDC_STATIC_SERIAL_NUMBER, m_staticSerialNumber);
	DDX_Control(pDX, IDC_BUTTON_EXPORT, m_btnExport);
	DDX_Control(pDX, IDC_BUTTON_SYNC, m_btnSync);
	DDX_Control(pDX, IDC_BUTTON_SNAPSHOT, m_btnSnapshot);
	DDX_Control(pDX, IDC_BUTTON_DEFAULT, m_btnDefault);
	DDX_Control(pDX, IDC_BUTTON_APPLY, m_btnApply);
	DDX_Control(pDX, IDC_BUTTON_PROPERTY_CH04, m_btnProperty04);
	DDX_Control(pDX, IDC_BUTTON_PROPERTY_CH03, m_btnProperty03);
	DDX_Control(pDX, IDC_BUTTON_PROPERTY_CH02, m_btnProperty02);
	DDX_Control(pDX, IDC_BUTTON_PROPERTY_CH01, m_btnProperty01);
	DDX_Control(pDX, IDC_COMBO_GOP_CH04, m_comboGOP04);
	DDX_Control(pDX, IDC_COMBO_GOP_CH03, m_comboGOP03);
	DDX_Control(pDX, IDC_COMBO_GOP_CH02, m_comboGOP02);
	DDX_Control(pDX, IDC_COMBO_GOP_CH01, m_comboGOP01);
	DDX_Control(pDX, IDC_COMBO_QUALITY_CH04, m_comboQuality04);
	DDX_Control(pDX, IDC_COMBO_QUALITY_CH03, m_comboQuality03);
	DDX_Control(pDX, IDC_COMBO_QUALITY_CH02, m_comboQuality02);
	DDX_Control(pDX, IDC_COMBO_QUALITY_CH01, m_comboQuality01);
	DDX_Control(pDX, IDC_COMBO_BITRATE_CH04, m_comboBitRate04);
	DDX_Control(pDX, IDC_COMBO_BITRATE_CH03, m_comboBitRate03);
	DDX_Control(pDX, IDC_COMBO_BITRATE_CH02, m_comboBitRate02);
	DDX_Control(pDX, IDC_COMBO_BITRATE_CH01, m_comboBitRate01);
	DDX_Control(pDX, IDC_COMBO_RECORDMODE_CH04, m_comboRecordMode04);
	DDX_Control(pDX, IDC_COMBO_RECORDMODE_CH03, m_comboRecordMode03);
	DDX_Control(pDX, IDC_COMBO_RECORDMODE_CH02, m_comboRecordMode02);
	DDX_Control(pDX, IDC_COMBO_RECORDMODE_CH01, m_comboRecordMode01);
	DDX_Control(pDX, IDC_COMBO_FRAMERATE_CH04, m_comboFrameRate04);
	DDX_Control(pDX, IDC_COMBO_FRAMERATE_CH03, m_comboFrameRate03);
	DDX_Control(pDX, IDC_COMBO_FRAMERATE_CH02, m_comboFrameRate02);
	DDX_Control(pDX, IDC_COMBO_FRAMERATE_CH01, m_comboFrameRate01);
	DDX_Control(pDX, IDC_COMBO_DEINTERLACE_CH04, m_comboDeinterlace04);
	DDX_Control(pDX, IDC_COMBO_DEINTERLACE_CH03, m_comboDeinterlace03);
	DDX_Control(pDX, IDC_COMBO_DEINTERLACE_CH02, m_comboDeinterlace02);
	DDX_Control(pDX, IDC_COMBO_DEINTERLACE_CH01, m_comboDeinterlace01);
	DDX_Control(pDX, IDC_COMBO_RESOLUTION_CH04, m_comboResolution04);
	DDX_Control(pDX, IDC_COMBO_RESOLUTION_CH03, m_comboResolution03);
	DDX_Control(pDX, IDC_COMBO_RESOLUTION_CH02, m_comboResolution02);
	DDX_Control(pDX, IDC_COMBO_RESOLUTION_CH01, m_comboResolution01);
	DDX_Control(pDX, IDC_COMBO_STANDARD, m_comboStandard);
	DDX_Control(pDX, IDC_EDIT_PROPERTY, m_editProperty);
	DDX_Control(pDX, IDC_EDIT_GOP, m_editGOP);
	DDX_Control(pDX, IDC_EDIT_QUALITY, m_editQuality);
	DDX_Control(pDX, IDC_EDIT_BITRATE, m_editBitRate);
	DDX_Control(pDX, IDC_EDIT_RECORDMODE, m_editRecordMode);
	DDX_Control(pDX, IDC_EDIT_FRAMERATE, m_editFrameRate);
	DDX_Control(pDX, IDC_EDIT_DEINTERLACE, m_editDeinterlace);
	DDX_Control(pDX, IDC_EDIT_RESOLUTION, m_editResolution);
	DDX_Control(pDX, IDC_EDIT_CHANNEL, m_editChannel);
	DDX_Control(pDX, IDC_EDIT_STANDARD, m_editStandard);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSetupDialog, CDialog)
	//{{AFX_MSG_MAP(CSetupDialog)
	ON_BN_CLICKED(IDC_BUTTON_APPLY, OnApply)
	ON_BN_CLICKED(IDC_BUTTON_DEFAULT, OnDefault)
	ON_CBN_SELCHANGE(IDC_COMBO_RECORDMODE_CH01, OnSelChangeComboRecordModeCh01)
	ON_CBN_SELCHANGE(IDC_COMBO_RECORDMODE_CH02, OnSelChangeComboRecordModeCh02)
	ON_CBN_SELCHANGE(IDC_COMBO_RECORDMODE_CH03, OnSelChangeComboRecordModeCh03)
	ON_CBN_SELCHANGE(IDC_COMBO_RECORDMODE_CH04, OnSelChangeComboRecordModeCh04)
	ON_CBN_SELCHANGE(IDC_COMBO_STANDARD, OnSelChangeComboStandard)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_SYNC, OnSync)
	ON_BN_CLICKED(IDC_BUTTON_EXPORT, OnExport)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_SNAPSHOT, OnSnapshot)
	ON_CBN_SELCHANGE(IDC_COMBO_RESOLUTION_CH01, OnSelChangeComboResolutionCh01)
	ON_CBN_SELCHANGE(IDC_COMBO_RESOLUTION_CH02, OnSelChangeComboResolutionCh02)
	ON_CBN_SELCHANGE(IDC_COMBO_RESOLUTION_CH03, OnSelChangeComboResolutionCh03)
	ON_CBN_SELCHANGE(IDC_COMBO_RESOLUTION_CH04, OnSelChangeComboResolutionCh04)
	ON_BN_CLICKED(IDC_BUTTON_PROPERTY_CH01, OnButtonPropertyCh01)
	ON_BN_CLICKED(IDC_BUTTON_PROPERTY_CH02, OnButtonPropertyCh02)
	ON_BN_CLICKED(IDC_BUTTON_PROPERTY_CH03, OnButtonPropertyCh03)
	ON_BN_CLICKED(IDC_BUTTON_PROPERTY_CH04, OnButtonPropertyCh04)

	ON_CBN_SELCHANGE(IDC_COMBO_STREAM, OnSelChangeComboStream)	
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetupDialog message handlers

extern VOID SC500_DEBUG( TCHAR * fmt, ... );

extern CSC500App theApp;

void CSetupDialog::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CSetupDialog::OnCancel() 
{
	// TODO: Add extra cleanup here
	
//	CDialog::OnCancel();
}

void CSetupDialog::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	
	KillTimer( 0x00000000 );

	m_oFileManagerWindow.DestroyWindow();
}

BOOL CSetupDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	ULONG cx = 96;

	ULONG cy = 25;

	ULONG xo = 0;

	ULONG yo = 0;	

	m_editStandard.MoveWindow( xo + (cx * 0), yo + (cy * 0), cx, cy );

	m_editChannel.MoveWindow( xo + (cx * 1), yo + (cy * 0), cx, cy );

	m_editResolution.MoveWindow( xo + (cx * 2), yo + (cy * 0), cx, cy );

	m_editDeinterlace.MoveWindow( xo + (cx * 3), yo + (cy * 0), cx, cy );

	m_editFrameRate.MoveWindow( xo + (cx * 4), yo + (cy * 0), cx, cy );

	m_editRecordMode.MoveWindow( xo + (cx * 5), yo + (cy * 0), cx, cy );

	m_editBitRate.MoveWindow( xo + (cx * 6), yo + (cy * 0), cx, cy );

	m_editQuality.MoveWindow( xo + (cx * 7), yo + (cy * 0), cx, cy );

	m_editGOP.MoveWindow( xo + (cx * 8), yo + (cy * 0), cx, cy );

	m_editProperty.MoveWindow( xo + (cx * 9), yo + (cy * 0), cx, cy );

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	m_comboStandard.MoveWindow( xo + (cx * 0), yo + (cy * 1), cx, cy + 200 );

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	m_editChannel01.MoveWindow( xo + (cx * 1), yo + (cy * 1), cx, cy - 1 );

	m_editChannel02.MoveWindow( xo + (cx * 1), yo + (cy * 2), cx, cy - 1 );

	m_editChannel03.MoveWindow( xo + (cx * 1), yo + (cy * 3), cx, cy - 1 );

	m_editChannel04.MoveWindow( xo + (cx * 1), yo + (cy * 4), cx, cy - 1 );

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	m_comboResolution01.MoveWindow( xo + (cx * 2), yo + (cy * 1), cx, cy + 200 );

	m_comboResolution02.MoveWindow( xo + (cx * 2), yo + (cy * 2), cx, cy + 200 );

	m_comboResolution03.MoveWindow( xo + (cx * 2), yo + (cy * 3), cx, cy + 200 );

	m_comboResolution04.MoveWindow( xo + (cx * 2), yo + (cy * 4), cx, cy + 200 );

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	m_comboDeinterlace01.MoveWindow( xo + (cx * 3), yo + (cy * 1), cx, cy + 200 );

	m_comboDeinterlace02.MoveWindow( xo + (cx * 3), yo + (cy * 2), cx, cy + 200 );

	m_comboDeinterlace03.MoveWindow( xo + (cx * 3), yo + (cy * 3), cx, cy + 200 );

	m_comboDeinterlace04.MoveWindow( xo + (cx * 3), yo + (cy * 4), cx, cy + 200 );

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	m_comboFrameRate01.MoveWindow( xo + (cx * 4), yo + (cy * 1), cx, cy + 200 );

	m_comboFrameRate02.MoveWindow( xo + (cx * 4), yo + (cy * 2), cx, cy + 200 );

	m_comboFrameRate03.MoveWindow( xo + (cx * 4), yo + (cy * 3), cx, cy + 200 );

	m_comboFrameRate04.MoveWindow( xo + (cx * 4), yo + (cy * 4), cx, cy + 200 );

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	m_comboRecordMode01.MoveWindow( xo + (cx * 5), yo + (cy * 1), cx, cy + 200 );

	m_comboRecordMode02.MoveWindow( xo + (cx * 5), yo + (cy * 2), cx, cy + 200 );

	m_comboRecordMode03.MoveWindow( xo + (cx * 5), yo + (cy * 3), cx, cy + 200 );

	m_comboRecordMode04.MoveWindow( xo + (cx * 5), yo + (cy * 4), cx, cy + 200 );

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	m_comboBitRate01.MoveWindow( xo + (cx * 6), yo + (cy * 1), cx, cy + 200 );

	m_comboBitRate02.MoveWindow( xo + (cx * 6), yo + (cy * 2), cx, cy + 200 );

	m_comboBitRate03.MoveWindow( xo + (cx * 6), yo + (cy * 3), cx, cy + 200 );

	m_comboBitRate04.MoveWindow( xo + (cx * 6), yo + (cy * 4), cx, cy + 200 );

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	m_comboQuality01.MoveWindow( xo + (cx * 7), yo + (cy * 1), cx, cy + 200 );

	m_comboQuality02.MoveWindow( xo + (cx * 7), yo + (cy * 2), cx, cy + 200 );

	m_comboQuality03.MoveWindow( xo + (cx * 7), yo + (cy * 3), cx, cy + 200 );

	m_comboQuality04.MoveWindow( xo + (cx * 7), yo + (cy * 4), cx, cy + 200 );

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	m_comboGOP01.MoveWindow( xo + (cx * 8), yo + (cy * 1), cx, cy + 200 );

	m_comboGOP02.MoveWindow( xo + (cx * 8), yo + (cy * 2), cx, cy + 200 );

	m_comboGOP03.MoveWindow( xo + (cx * 8), yo + (cy * 3), cx, cy + 200 );

	m_comboGOP04.MoveWindow( xo + (cx * 8), yo + (cy * 4), cx, cy + 200 );

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	m_btnProperty01.MoveWindow( xo + (cx * 9), yo + (cy * 1), cx, cy );

	m_btnProperty02.MoveWindow( xo + (cx * 9), yo + (cy * 2), cx, cy );

	m_btnProperty03.MoveWindow( xo + (cx * 9), yo + (cy * 3), cx, cy );

	m_btnProperty04.MoveWindow( xo + (cx * 9), yo + (cy * 4), cx, cy );

	for( ULONG i = 1 ; i <= 255 ; i++ ) {

		CHAR psz[ 16 ]; 
		
		sprintf( psz, "%3d", i );

		m_comboGOP01.AddString( psz );

		m_comboGOP02.AddString( psz );

		m_comboGOP03.AddString( psz );

		m_comboGOP04.AddString( psz );
	}
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	m_btnSnapshot.MoveWindow( xo + (cx * 7), yo + (cy * 5), cx, cy );

	m_btnDefault.MoveWindow( xo + (cx * 8), yo + (cy * 5), cx, cy );

	m_btnApply.MoveWindow( xo + (cx * 9), yo + (cy * 5), cx, cy );

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	{	ULONG xe = xo;
		
		for( i = 0 ; i < 24 ; i++ ) {

			ULONG cx = 40;

			CHAR psz[ 16 ]; 
			
			sprintf( psz, "%02d", i );

		  ::MoveWindow( ::GetDlgItem( m_hWnd, IDC_EDIT_HOUR01 + i ), xe, yo + (cy * 0), cx, cy, FALSE );

		  ::SetWindowText( ::GetDlgItem( m_hWnd, IDC_EDIT_HOUR01 + i ), psz );

		  ::ShowWindow( ::GetDlgItem( m_hWnd, IDC_EDIT_HOUR01 + i ), FALSE );

			xe += cx;
		}
	}
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	m_oFileManagerWindow.Create( NULL, "MyFileManagerWindow", WS_CHILD | WS_VISIBLE | WS_BORDER, CRect( 0, 0, 0, 0 ), this, 0x00000000, NULL );

	m_oFileManagerWindow.MoveWindow( xo + (cx * 0), yo + (cy * 1), cx * 10, 52 );

	m_oFileManagerWindow.ShowWindow( FALSE );
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	m_progressExport.SetRange( 0, 100 );

	m_progressExport.MoveWindow( xo + (cx * 5), yo + (cy * 5), cx + cx, cy );

	m_btnExport.MoveWindow( xo + (cx * 8), yo + (cy * 5), cx, cy );

	m_btnSync.MoveWindow( xo + (cx * 9), yo + (cy * 5), cx, cy );

	m_progressExport.ShowWindow( FALSE );

	m_btnExport.ShowWindow( FALSE );

	m_btnSync.ShowWindow( FALSE );

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	// GET DEFAULT RECORD PATH
	// 
	ULARGE_INTEGER nMaxFreeBytesAvailable = { 0, 0 };

	ULARGE_INTEGER nMaxTotalNumberOfBytes = { 0, 0 };

	ULARGE_INTEGER nMaxTotalNumberOfFreeBytes = { 0, 0 };

	CHAR psz[ MAX_PATH ];

	m_nLargestAvailableDiskNumber = 0;

	for( i = 0 ; i < 24 ; i++ ) { // ENUM ALL AVAILABLE DISKS & FIND OUT THE LARGEST (FREE SPACE) ONE DISK

		ULARGE_INTEGER nFreeBytesAvailable;

		ULARGE_INTEGER nTotalNumberOfBytes;

		ULARGE_INTEGER nTotalNumberOfFreeBytes;

		CHAR psz[ MAX_PATH ] = "C:\\"; sprintf( psz, "%C:\\", 'C' + i );

		if( FALSE == GetDiskFreeSpaceEx( psz, &nFreeBytesAvailable, &nTotalNumberOfBytes, &nTotalNumberOfFreeBytes ) ) { continue; }

		if( nTotalNumberOfFreeBytes.QuadPart == 0 ) { continue; }

		if( nTotalNumberOfFreeBytes.QuadPart > nMaxTotalNumberOfFreeBytes.QuadPart ) {

			nMaxFreeBytesAvailable = nMaxFreeBytesAvailable;

			nMaxTotalNumberOfBytes = nTotalNumberOfBytes;

			nMaxTotalNumberOfFreeBytes = nTotalNumberOfFreeBytes;

			m_nLargestAvailableDiskNumber = i;
		}
	}
	sprintf( psz, "%C:\\SC500\\", 'C' + m_nLargestAvailableDiskNumber );

	CreateDirectory( psz, NULL );

	sprintf( psz, "%C:\\SC500\\CH01\\", 'C' + m_nLargestAvailableDiskNumber );

	CreateDirectory( psz, NULL );

	sprintf( psz, "%C:\\SC500\\CH02\\", 'C' + m_nLargestAvailableDiskNumber );

	CreateDirectory( psz, NULL );

	sprintf( psz, "%C:\\SC500\\CH03\\", 'C' + m_nLargestAvailableDiskNumber );

	CreateDirectory( psz, NULL );

	sprintf( psz, "%C:\\SC500\\CH04\\", 'C' + m_nLargestAvailableDiskNumber );

	CreateDirectory( psz, NULL );

	sprintf( psz, "%C:\\BACKUP\\", 'C' + m_nLargestAvailableDiskNumber );

	CreateDirectory( psz, NULL );

	sprintf( psz, "RECORD PATH = %C:\\SC500\\", 'C' + m_nLargestAvailableDiskNumber );

	m_staticRecordPath.SetWindowText( psz );

	m_staticRecordPath.MoveWindow( xo + (cx * 0) + 3, yo + (cy * 4) + 3, 200, cy, TRUE );

	m_staticRecordPath.ShowWindow( FALSE );

	sprintf( psz, "EXPORT PATH = %C:\\BACKUP\\", 'C' + m_nLargestAvailableDiskNumber );

	m_staticExportPath.SetWindowText( psz );

	m_staticExportPath.MoveWindow( xo + (cx * 0) + 3, yo + (cy * 5) + 3, 200, cy, TRUE );

	m_staticExportPath.ShowWindow( FALSE );

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	m_staticSerialNumber.SetWindowText( "SERIAL NUMBER = 0x00000000" );

	m_staticSerialNumber.MoveWindow( xo + (cx * 0) + 3, yo + (cy * 3) + 3, 300, cy, TRUE );

	m_staticSerialNumber.ShowWindow( FALSE );

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	OnDefault();

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	m_oFileManagerWindow.EnumFileInfoFromDisk( m_nLargestAvailableDiskNumber, TRUE );

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	SetTimer( 0x00000000, 1000, NULL );

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CSetupDialog::OnSelChangeTabDisplay_SC500Dlg( ULONG nDisplayModeNumber )
{
	ULONG i = 0;

	if( nDisplayModeNumber == 0x00000000 ) {

		for( i = 0 ; i < 10 ; i++ ) {

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 2000 + i ), TRUE  );
		}
		for( i = 0 ; i < 1 ; i++ ) {

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 2100 + i ), TRUE  );
		}
		for( i = 0 ; i < 4 ; i++ ) {

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 2200 + i ), TRUE  );

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 2300 + i ), TRUE  );

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 2400 + i ), TRUE  );

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 2500 + i ), TRUE  );

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 2600 + i ), TRUE  );

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 2700 + i ), TRUE  );

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 2800 + i ), TRUE  );

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 2900 + i ), TRUE  );

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 3000 + i ), TRUE  );
		}
		for( i = 0 ; i < 24 ; i++ ) {

		  ::ShowWindow( ::GetDlgItem( m_hWnd, IDC_EDIT_HOUR01 + i ), FALSE );
		}
		m_btnSnapshot.ShowWindow( TRUE );

		m_btnDefault.ShowWindow( TRUE );

		m_btnApply.ShowWindow( TRUE );

		m_staticSerialNumber.ShowWindow( FALSE );

		m_staticRecordPath.ShowWindow( FALSE );

		m_staticExportPath.ShowWindow( FALSE );

		m_progressExport.ShowWindow( FALSE );

		m_btnExport.ShowWindow( FALSE );

		m_btnSync.ShowWindow( FALSE );

		m_oFileManagerWindow.ShowWindow( FALSE );
	}
	if( nDisplayModeNumber == 0x00000001 ) {

		for( i = 0 ; i < 24 ; i++ ) {

		  ::ShowWindow( ::GetDlgItem( m_hWnd, IDC_EDIT_HOUR01 + i ), TRUE  );
		}
		for( i = 0 ; i < 10 ; i++ ) {

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 2000 + i ), FALSE );
		}
		for( i = 0 ; i < 1 ; i++ ) {

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 2100 + i ), FALSE );
		}
		for( i = 0 ; i < 4 ; i++ ) {

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 2200 + i ), FALSE );

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 2300 + i ), FALSE );

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 2400 + i ), FALSE );

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 2500 + i ), FALSE );

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 2600 + i ), FALSE );

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 2700 + i ), FALSE );

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 2800 + i ), FALSE );

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 2900 + i ), FALSE );

		  ::ShowWindow( ::GetDlgItem( m_hWnd, 3000 + i ), FALSE );
		}
		// GET SERIAL NUMBER
		//
		{	CSC500Dlg * pParent = (CSC500Dlg *)(GetParent());

			ULONG nSerialNumber = 0x00000000;

			CHAR psz[ MAX_PATH ]; 
				
			AMESDK_GET_CUSTOM_PROPERTY( pParent->m_hVideoDev[ 0 ], 0, &nSerialNumber );

			sprintf( psz, "SERIAL NUMBER = 0x%08X", nSerialNumber );

			m_staticSerialNumber.SetWindowText( psz );
		}
		m_staticSerialNumber.ShowWindow( TRUE );

		m_staticRecordPath.ShowWindow( TRUE );

		m_staticExportPath.ShowWindow( TRUE );

		m_oFileManagerWindow.ShowWindow( TRUE );

		m_progressExport.ShowWindow( TRUE );

		m_btnSnapshot.ShowWindow( TRUE );

		m_btnExport.ShowWindow( TRUE );

		m_btnSync.ShowWindow( TRUE );

		m_btnDefault.ShowWindow( FALSE );

		m_btnApply.ShowWindow( FALSE );
	}
	return TRUE;
}



void CSetupDialog::OnSelChangeComboStream() 
{
	CSC500Dlg * pParent = (CSC500Dlg *)(GetParent());
}

void CSetupDialog::OnSelChangeComboStandard() 
{
	// TODO: Add your control notification handler code here

	ULONG i = m_comboStandard.GetCurSel();

	if( i == 0 ) { ULONG j = m_comboResolution01.GetCurSel(); m_comboResolution01.ResetContent(); m_comboResolution01.AddString( "1920X1080" ); m_comboResolution01.AddString( "1280X720" ); m_comboResolution01.AddString( "720X480" ); m_comboResolution01.SetCurSel( j ); }

	if( i == 0 ) { ULONG j = m_comboResolution02.GetCurSel(); m_comboResolution02.ResetContent(); m_comboResolution02.AddString( "1920X1080" ); m_comboResolution02.AddString( "1280X720" ); m_comboResolution02.AddString( "720X480" ); m_comboResolution02.SetCurSel( j ); }

	if( i == 0 ) { ULONG j = m_comboResolution03.GetCurSel(); m_comboResolution03.ResetContent(); m_comboResolution03.AddString( "1920X1080" ); m_comboResolution03.AddString( "1280X720" ); m_comboResolution03.AddString( "720X480" ); m_comboResolution03.SetCurSel( j ); }

	if( i == 0 ) { ULONG j = m_comboResolution04.GetCurSel(); m_comboResolution04.ResetContent(); m_comboResolution04.AddString( "1920X1080" ); m_comboResolution04.AddString( "1280X720" ); m_comboResolution04.AddString( "720X480" ); m_comboResolution04.SetCurSel( j ); }

	if( i == 1 ) { ULONG j = m_comboResolution01.GetCurSel(); m_comboResolution01.ResetContent(); m_comboResolution01.AddString( "1920X1080" ); m_comboResolution01.AddString( "1280X720" ); m_comboResolution01.AddString( "720X576" ); m_comboResolution01.SetCurSel( j ); }

	if( i == 1 ) { ULONG j = m_comboResolution02.GetCurSel(); m_comboResolution02.ResetContent(); m_comboResolution02.AddString( "1920X1080" ); m_comboResolution02.AddString( "1280X720" ); m_comboResolution02.AddString( "720X576" ); m_comboResolution02.SetCurSel( j ); }

	if( i == 1 ) { ULONG j = m_comboResolution03.GetCurSel(); m_comboResolution03.ResetContent(); m_comboResolution03.AddString( "1920X1080" ); m_comboResolution03.AddString( "1280X720" ); m_comboResolution03.AddString( "720X576" ); m_comboResolution03.SetCurSel( j ); }

	if( i == 1 ) { ULONG j = m_comboResolution04.GetCurSel(); m_comboResolution04.ResetContent(); m_comboResolution04.AddString( "1920X1080" ); m_comboResolution04.AddString( "1280X720" ); m_comboResolution04.AddString( "720X576" ); m_comboResolution04.SetCurSel( j ); }

	if( i == 0 ) { ULONG r = m_comboResolution01.GetCurSel(); ULONG j = m_comboFrameRate01.GetCurSel(); m_comboFrameRate01.ResetContent(); m_comboFrameRate01.AddString( (r == 0) ? "30.000" : "60.000" ); m_comboFrameRate01.AddString( "30.000" ); m_comboFrameRate01.AddString( "15.000" ); m_comboFrameRate01.AddString( " 7.500" ); m_comboFrameRate01.AddString( " 3.750" ); m_comboFrameRate01.SetCurSel( j ); }

	if( i == 0 ) { ULONG r = m_comboResolution02.GetCurSel(); ULONG j = m_comboFrameRate02.GetCurSel(); m_comboFrameRate02.ResetContent(); m_comboFrameRate02.AddString( (r == 0) ? "30.000" : "60.000" ); m_comboFrameRate02.AddString( "30.000" ); m_comboFrameRate02.AddString( "15.000" ); m_comboFrameRate02.AddString( " 7.500" ); m_comboFrameRate02.AddString( " 3.750" ); m_comboFrameRate02.SetCurSel( j ); }

	if( i == 0 ) { ULONG r = m_comboResolution03.GetCurSel(); ULONG j = m_comboFrameRate03.GetCurSel(); m_comboFrameRate03.ResetContent(); m_comboFrameRate03.AddString( (r == 0) ? "30.000" : "60.000" ); m_comboFrameRate03.AddString( "30.000" ); m_comboFrameRate03.AddString( "15.000" ); m_comboFrameRate03.AddString( " 7.500" ); m_comboFrameRate03.AddString( " 3.750" ); m_comboFrameRate03.SetCurSel( j ); }

	if( i == 0 ) { ULONG r = m_comboResolution04.GetCurSel(); ULONG j = m_comboFrameRate04.GetCurSel(); m_comboFrameRate04.ResetContent(); m_comboFrameRate04.AddString( (r == 0) ? "30.000" : "60.000" ); m_comboFrameRate04.AddString( "30.000" ); m_comboFrameRate04.AddString( "15.000" ); m_comboFrameRate04.AddString( " 7.500" ); m_comboFrameRate04.AddString( " 3.750" ); m_comboFrameRate04.SetCurSel( j ); }

	if( i == 1 ) { ULONG r = m_comboResolution01.GetCurSel(); ULONG j = m_comboFrameRate01.GetCurSel(); m_comboFrameRate01.ResetContent(); m_comboFrameRate01.AddString( (r == 0) ? "25.000" : "50.000" ); m_comboFrameRate01.AddString( "25.000" ); m_comboFrameRate01.AddString( "12.500" ); m_comboFrameRate01.AddString( " 6.250" ); m_comboFrameRate01.AddString( " 3.125" ); m_comboFrameRate01.SetCurSel( j ); }

	if( i == 1 ) { ULONG r = m_comboResolution02.GetCurSel(); ULONG j = m_comboFrameRate02.GetCurSel(); m_comboFrameRate02.ResetContent(); m_comboFrameRate02.AddString( (r == 0) ? "25.000" : "50.000" ); m_comboFrameRate02.AddString( "25.000" ); m_comboFrameRate02.AddString( "12.500" ); m_comboFrameRate02.AddString( " 6.250" ); m_comboFrameRate02.AddString( " 3.125" ); m_comboFrameRate02.SetCurSel( j ); }

	if( i == 1 ) { ULONG r = m_comboResolution03.GetCurSel(); ULONG j = m_comboFrameRate03.GetCurSel(); m_comboFrameRate03.ResetContent(); m_comboFrameRate03.AddString( (r == 0) ? "25.000" : "50.000" ); m_comboFrameRate03.AddString( "25.000" ); m_comboFrameRate03.AddString( "12.500" ); m_comboFrameRate03.AddString( " 6.250" ); m_comboFrameRate03.AddString( " 3.125" ); m_comboFrameRate03.SetCurSel( j ); }

	if( i == 1 ) { ULONG r = m_comboResolution04.GetCurSel(); ULONG j = m_comboFrameRate04.GetCurSel(); m_comboFrameRate04.ResetContent(); m_comboFrameRate04.AddString( (r == 0) ? "25.000" : "50.000" ); m_comboFrameRate04.AddString( "25.000" ); m_comboFrameRate04.AddString( "12.500" ); m_comboFrameRate04.AddString( " 6.250" ); m_comboFrameRate04.AddString( " 3.125" ); m_comboFrameRate04.SetCurSel( j ); }
}

void CSetupDialog::OnSelChangeComboResolutionCh01() 
{
	// TODO: Add your control notification handler code here

	ULONG i = m_comboStandard.GetCurSel();

	ULONG r = m_comboResolution01.GetCurSel();

	if( i == 0 ) { ULONG j = m_comboFrameRate01.GetCurSel(); m_comboFrameRate01.ResetContent(); m_comboFrameRate01.AddString( (r == 0) ? "30.000" : "60.000" ); m_comboFrameRate01.AddString( "30.000" ); m_comboFrameRate01.AddString( "15.000" ); m_comboFrameRate01.AddString( " 7.500" ); m_comboFrameRate01.AddString( " 3.750" ); m_comboFrameRate01.SetCurSel( j ); }

	if( i == 1 ) { ULONG j = m_comboFrameRate01.GetCurSel(); m_comboFrameRate01.ResetContent(); m_comboFrameRate01.AddString( (r == 0) ? "25.000" : "50.000" ); m_comboFrameRate01.AddString( "25.000" ); m_comboFrameRate01.AddString( "12.500" ); m_comboFrameRate01.AddString( " 6.250" ); m_comboFrameRate01.AddString( " 3.125" ); m_comboFrameRate01.SetCurSel( j ); }
}

void CSetupDialog::OnSelChangeComboResolutionCh02() 
{
	// TODO: Add your control notification handler code here

	ULONG i = m_comboStandard.GetCurSel();

	ULONG r = m_comboResolution02.GetCurSel();

	if( i == 0 ) { ULONG j = m_comboFrameRate02.GetCurSel(); m_comboFrameRate02.ResetContent(); m_comboFrameRate02.AddString( (r == 0) ? "30.000" : "60.000" ); m_comboFrameRate02.AddString( "30.000" ); m_comboFrameRate02.AddString( "15.000" ); m_comboFrameRate02.AddString( " 7.500" ); m_comboFrameRate02.AddString( " 3.750" ); m_comboFrameRate02.SetCurSel( j ); }

	if( i == 1 ) { ULONG j = m_comboFrameRate02.GetCurSel(); m_comboFrameRate02.ResetContent(); m_comboFrameRate02.AddString( (r == 0) ? "25.000" : "50.000" ); m_comboFrameRate02.AddString( "25.000" ); m_comboFrameRate02.AddString( "12.500" ); m_comboFrameRate02.AddString( " 6.250" ); m_comboFrameRate02.AddString( " 3.125" ); m_comboFrameRate02.SetCurSel( j ); }	
}

void CSetupDialog::OnSelChangeComboResolutionCh03() 
{
	// TODO: Add your control notification handler code here

	ULONG i = m_comboStandard.GetCurSel();

	ULONG r = m_comboResolution03.GetCurSel();

	if( i == 0 ) { ULONG j = m_comboFrameRate03.GetCurSel(); m_comboFrameRate03.ResetContent(); m_comboFrameRate03.AddString( (r == 0) ? "30.000" : "60.000" ); m_comboFrameRate03.AddString( "30.000" ); m_comboFrameRate03.AddString( "15.000" ); m_comboFrameRate03.AddString( " 7.500" ); m_comboFrameRate03.AddString( " 3.750" ); m_comboFrameRate03.SetCurSel( j ); }

	if( i == 1 ) { ULONG j = m_comboFrameRate03.GetCurSel(); m_comboFrameRate03.ResetContent(); m_comboFrameRate03.AddString( (r == 0) ? "25.000" : "50.000" ); m_comboFrameRate03.AddString( "25.000" ); m_comboFrameRate03.AddString( "12.500" ); m_comboFrameRate03.AddString( " 6.250" ); m_comboFrameRate03.AddString( " 3.125" ); m_comboFrameRate03.SetCurSel( j ); }	
}

void CSetupDialog::OnSelChangeComboResolutionCh04() 
{
	// TODO: Add your control notification handler code here

	ULONG i = m_comboStandard.GetCurSel();

	ULONG r = m_comboResolution04.GetCurSel();

	if( i == 0 ) { ULONG j = m_comboFrameRate04.GetCurSel(); m_comboFrameRate04.ResetContent(); m_comboFrameRate04.AddString( (r == 0) ? "30.000" : "60.000" ); m_comboFrameRate04.AddString( "30.000" ); m_comboFrameRate04.AddString( "15.000" ); m_comboFrameRate04.AddString( " 7.500" ); m_comboFrameRate04.AddString( " 3.750" ); m_comboFrameRate04.SetCurSel( j ); }

	if( i == 1 ) { ULONG j = m_comboFrameRate04.GetCurSel(); m_comboFrameRate04.ResetContent(); m_comboFrameRate04.AddString( (r == 0) ? "25.000" : "50.000" ); m_comboFrameRate04.AddString( "25.000" ); m_comboFrameRate04.AddString( "12.500" ); m_comboFrameRate04.AddString( " 6.250" ); m_comboFrameRate04.AddString( " 3.125" ); m_comboFrameRate04.SetCurSel( j ); }	
}

void CSetupDialog::OnSelChangeComboRecordModeCh01() 
{
	// TODO: Add your control notification handler code here
	
	ULONG i = m_comboRecordMode01.GetCurSel();

	if( i == 0 ) { m_comboBitRate01.EnableWindow( FALSE ); }

	if( i == 0 ) { m_comboQuality01.EnableWindow( TRUE  ); }

	if( i == 1 ) { m_comboBitRate01.EnableWindow( TRUE  ); }

	if( i == 1 ) { m_comboQuality01.EnableWindow( FALSE ); }
}

void CSetupDialog::OnSelChangeComboRecordModeCh02() 
{
	// TODO: Add your control notification handler code here
	
	ULONG i = m_comboRecordMode02.GetCurSel();

	if( i == 0 ) { m_comboBitRate02.EnableWindow( FALSE ); }

	if( i == 0 ) { m_comboQuality02.EnableWindow( TRUE  ); }

	if( i == 1 ) { m_comboBitRate02.EnableWindow( TRUE  ); }

	if( i == 1 ) { m_comboQuality02.EnableWindow( FALSE ); }
}

void CSetupDialog::OnSelChangeComboRecordModeCh03() 
{
	// TODO: Add your control notification handler code here
	
	ULONG i = m_comboRecordMode03.GetCurSel();

	if( i == 0 ) { m_comboBitRate03.EnableWindow( FALSE ); }

	if( i == 0 ) { m_comboQuality03.EnableWindow( TRUE  ); }

	if( i == 1 ) { m_comboBitRate03.EnableWindow( TRUE  ); }

	if( i == 1 ) { m_comboQuality03.EnableWindow( FALSE ); }
}

void CSetupDialog::OnSelChangeComboRecordModeCh04() 
{
	// TODO: Add your control notification handler code here
	
	ULONG i = m_comboRecordMode04.GetCurSel();

	if( i == 0 ) { m_comboBitRate04.EnableWindow( FALSE ); }

	if( i == 0 ) { m_comboQuality04.EnableWindow( TRUE  ); }

	if( i == 1 ) { m_comboBitRate04.EnableWindow( TRUE  ); }

	if( i == 1 ) { m_comboQuality04.EnableWindow( FALSE ); }	
}

void CSetupDialog::OnSnapshot() 
{
	// TODO: Add your control notification handler code here

	{	CSC500Dlg * pParent = (CSC500Dlg *)(GetParent());
	
		pParent->OnSnapshot_SetupDialog();
	}	
}

void CSetupDialog::OnDefault() 
{
	// TODO: Add your control notification handler code here
	
	m_editStandard.SetWindowText( "STANDARD" );

	m_editChannel.SetWindowText( "CHANNEL" );

	m_editResolution.SetWindowText( "RESOLUTION" );

	m_editDeinterlace.SetWindowText( "DEINTERLACE" );

	m_editFrameRate.SetWindowText( "FRAMERATE" );

	m_editRecordMode.SetWindowText( "RECORDMODE" );

	m_editBitRate.SetWindowText( "BITRATE" );

	m_editQuality.SetWindowText( "QUALITY" );

	m_editGOP.SetWindowText( "GOP" );

	m_editProperty.SetWindowText( "PROPERTY" );

	m_comboStandard.SetCurSel( SC500_CUR_STANDARD );

	m_editChannel01.SetWindowText( "CH01" );

	m_editChannel02.SetWindowText( "CH02" );

	m_editChannel03.SetWindowText( "CH03" );

	m_editChannel04.SetWindowText( "CH04" );

	m_comboResolution01.SetCurSel( 0 /*1920 X 1080*/ );

	m_comboResolution02.SetCurSel( 0 /*1920 X 1080*/ );

	m_comboResolution03.SetCurSel( 0 /*1920 X 1080*/ );

	m_comboResolution04.SetCurSel( 0 /*1920 X 1080*/ );

	m_comboDeinterlace01.SetCurSel( 0 /*METHOD#00*/ );

	m_comboDeinterlace02.SetCurSel( 0 /*METHOD#00*/ );

	m_comboDeinterlace03.SetCurSel( 0 /*METHOD#00*/ );

	m_comboDeinterlace04.SetCurSel( 0 /*METHOD#00*/ );

	m_comboFrameRate01.SetCurSel( 0 /*59.940*/ );

	m_comboFrameRate02.SetCurSel( 0 /*59.940*/ );

	m_comboFrameRate03.SetCurSel( 0 /*59.940*/ );

	m_comboFrameRate04.SetCurSel( 0 /*59.940*/ );

	m_comboRecordMode01.SetCurSel( 0 /*VBR*/ );

	m_comboRecordMode02.SetCurSel( 0 /*VBR*/ );

	m_comboRecordMode03.SetCurSel( 0 /*VBR*/ );

	m_comboRecordMode04.SetCurSel( 0 /*VBR*/ );

	m_comboBitRate01.SetCurSel( 4 /*4,096 KB*/ );

	m_comboBitRate02.SetCurSel( 4 /*4,096 KB*/ );

	m_comboBitRate03.SetCurSel( 4 /*4,096 KB*/ );

	m_comboBitRate04.SetCurSel( 4 /*4,096 KB*/ );

	m_comboQuality01.SetCurSel( 4 /*8,000*/ );

	m_comboQuality02.SetCurSel( 4 /*8,000*/ );

	m_comboQuality03.SetCurSel( 4 /*8,000*/ );

	m_comboQuality04.SetCurSel( 4 /*8,000*/ );

	m_comboGOP01.SetCurSel( 29 /*30*/ );

	m_comboGOP02.SetCurSel( 29 /*30*/ );

	m_comboGOP03.SetCurSel( 29 /*30*/ );

	m_comboGOP04.SetCurSel( 29 /*30*/ );

	OnSelChangeComboResolutionCh01();

	OnSelChangeComboResolutionCh02();

	OnSelChangeComboResolutionCh03();

	OnSelChangeComboResolutionCh04();

	OnSelChangeComboRecordModeCh01();

	OnSelChangeComboRecordModeCh02();

	OnSelChangeComboRecordModeCh03();

	OnSelChangeComboRecordModeCh04();

	OnSelChangeComboStandard();
}

void CSetupDialog::OnApply() 
{
	// TODO: Add your control notification handler code here

	{	CSC500Dlg * pParent = (CSC500Dlg *)(GetParent());
	
		pParent->OnApply_SetupDialog();

		m_oFileManagerWindow.EnumFileInfoFromDisk( m_nLargestAvailableDiskNumber, FALSE );
	}
}

void CSetupDialog::OnExport() 
{
	// TODO: Add your control notification handler code here

	{	CSC500Dlg * pParent = (CSC500Dlg *)(GetParent());
	
		pParent->OnApply_SetupDialog();
		
		m_oFileManagerWindow.EnumFileInfoFromDisk( m_nLargestAvailableDiskNumber, FALSE );

		m_oFileManagerWindow.ExportFileToDisk( m_nLargestAvailableDiskNumber );
	}
}

void CSetupDialog::OnSync() 
{
	// TODO: Add your control notification handler code here
	
	{	CSC500Dlg * pParent = (CSC500Dlg *)(GetParent());
	
		pParent->OnSync_SetupDialog();

		m_oFileManagerWindow.EnumFileInfoFromDisk( m_nLargestAvailableDiskNumber, FALSE );
	}
}

extern volatile ULONG g_n_export_file_to_disk_thread_pregress[ 4 ];

void CSetupDialog::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if( nIDEvent == 0x00000000 ) {

		m_progressExport.SetPos( (g_n_export_file_to_disk_thread_pregress[ 0 ] + 
			
								  g_n_export_file_to_disk_thread_pregress[ 1 ] + 
			
								  g_n_export_file_to_disk_thread_pregress[ 2 ] + 
			
								  g_n_export_file_to_disk_thread_pregress[ 3 ]) / 4 );
	}
	CDialog::OnTimer(nIDEvent);
}

BOOL CSetupDialog::GetStandardParameters( ULONG * pStandard )
{
	if( pStandard == NULL ) { return FALSE; }

	UpdateData( TRUE );

	ULONG i = m_comboStandard.GetCurSel();

	if( i == 0 ) { pStandard[ 0 ] = 0x00000001; }

	if( i == 1 ) { pStandard[ 0 ] = 0x00000010; }

	SC500_DEBUG( "STANDARD = %08X", pStandard[ 0 ] );

	return TRUE;
}

BOOL CSetupDialog::GetResolutionParameters( ULONG * pFrameWidth, ULONG * pFrameHeight )
{
	if( pFrameWidth == NULL ) { return FALSE; }

	if( pFrameHeight == NULL ) { return FALSE; }

	UpdateData( TRUE );

	ULONG std = m_comboStandard.GetCurSel();

	for( ULONG i = 0 ; i < 4 ; i++ ) {

		ULONG j = 0;

		if( i == 0 ) { j = m_comboResolution01.GetCurSel(); }

		if( i == 1 ) { j = m_comboResolution02.GetCurSel(); }

		if( i == 2 ) { j = m_comboResolution03.GetCurSel(); }

		if( i == 3 ) { j = m_comboResolution04.GetCurSel(); }

		if( j == 0 ) { pFrameWidth[ i ] = 1920; pFrameHeight[ i ] = (std == 0) ? 1080 : 1080; }

		if( j == 1 ) { pFrameWidth[ i ] = 1280; pFrameHeight[ i ] = (std == 0) ?  720 :  720; }

		if( j == 2 ) { pFrameWidth[ i ] =  720; pFrameHeight[ i ] = (std == 0) ?  480 :  576; }
	}
	SC500_DEBUG( "CH01 RESOLUTION = %d X %d", pFrameWidth[ 0 ], pFrameHeight[ 0 ] );

	SC500_DEBUG( "CH02 RESOLUTION = %d X %d", pFrameWidth[ 1 ], pFrameHeight[ 1 ] );

	SC500_DEBUG( "CH03 RESOLUTION = %d X %d", pFrameWidth[ 2 ], pFrameHeight[ 2 ] );

	SC500_DEBUG( "CH04 RESOLUTION = %d X %d", pFrameWidth[ 3 ], pFrameHeight[ 3 ] );

	return TRUE;
}

BOOL CSetupDialog::GetDeinterlaceParameters( ULONG * pDeinterlace )
{
	if( pDeinterlace == NULL ) { return FALSE; }

	UpdateData( TRUE );

	for( ULONG i = 0 ; i < 4 ; i++ ) {

		ULONG j = 0;

		if( i == 0 ) { j = m_comboDeinterlace01.GetCurSel(); }

		if( i == 1 ) { j = m_comboDeinterlace02.GetCurSel(); }

		if( i == 2 ) { j = m_comboDeinterlace03.GetCurSel(); }

		if( i == 3 ) { j = m_comboDeinterlace04.GetCurSel(); }

		if( j == 0 ) { pDeinterlace[ i ] = 0x00000000; }

		if( j == 1 ) { pDeinterlace[ i ] = 0x00000001; }

		if( j == 2 ) { pDeinterlace[ i ] = 0x00000002; }

		if( j == 3 ) { pDeinterlace[ i ] = 0x00000007; }
	}
	SC500_DEBUG( "CH01 DEINTERLACE = %d", pDeinterlace[ 0 ] );

	SC500_DEBUG( "CH02 DEINTERLACE = %d", pDeinterlace[ 1 ] );

	SC500_DEBUG( "CH03 DEINTERLACE = %d", pDeinterlace[ 2 ] );

	SC500_DEBUG( "CH04 DEINTERLACE = %d", pDeinterlace[ 3 ] );

	return TRUE;
}

BOOL CSetupDialog::GetFrameRateParameters( double * pFrameRate )
{
	if( pFrameRate == NULL ) { return FALSE; }

	UpdateData( TRUE );

	ULONG std = m_comboStandard.GetCurSel();

	ULONG cx[ 4 ] = { 0, 0, 0, 0 };

	ULONG cy[ 4 ] = { 0, 0, 0, 0 };

	GetResolutionParameters( cx, cy );

	for( ULONG i = 0 ; i < 4 ; i++ ) {

		ULONG j = 0;

		if( i == 0 ) { j = m_comboFrameRate01.GetCurSel(); }

		if( i == 1 ) { j = m_comboFrameRate02.GetCurSel(); }

		if( i == 2 ) { j = m_comboFrameRate03.GetCurSel(); }

		if( i == 3 ) { j = m_comboFrameRate04.GetCurSel(); }

		if( j == 0 ) { 

			if( cy[ i ] == 1080 ) {

				pFrameRate[ i ] = (std == 0) ? (59.940 / 2) : (50.000 / 2);
			}
			else {

				pFrameRate[ i ] = (std == 0) ? (59.940 / 1) : (50.000 / 1);
			}
		}
		if( j == 1 ) { pFrameRate[ i ] = (std == 0) ? (59.940 /  2) : (50.000 /  2); }

		if( j == 2 ) { pFrameRate[ i ] = (std == 0) ? (59.940 /  4) : (50.000 /  4); }

		if( j == 3 ) { pFrameRate[ i ] = (std == 0) ? (59.940 /  8) : (50.000 /  8); }

		if( j == 4 ) { pFrameRate[ i ] = (std == 0) ? (59.940 / 16) : (50.000 / 16); }
	}
	SC500_DEBUG( "CH01 FRAME RATE = %2.6f", pFrameRate[ 0 ] );

	SC500_DEBUG( "CH02 FRAME RATE = %2.6f", pFrameRate[ 1 ] );

	SC500_DEBUG( "CH03 FRAME RATE = %2.6f", pFrameRate[ 2 ] );

	SC500_DEBUG( "CH04 FRAME RATE = %2.6f", pFrameRate[ 3 ] );

	return TRUE;
}

BOOL CSetupDialog::GetRecordModeParameters( ULONG * pRecordMode )
{
	if( pRecordMode == NULL ) { return FALSE; }

	UpdateData( TRUE );

	pRecordMode[ 0 ] = m_comboRecordMode01.GetCurSel();

	pRecordMode[ 1 ] = m_comboRecordMode02.GetCurSel();

	pRecordMode[ 2 ] = m_comboRecordMode03.GetCurSel();

	pRecordMode[ 3 ] = m_comboRecordMode04.GetCurSel();

	SC500_DEBUG( "CH01 RECORD MODE = %d", pRecordMode[ 0 ] );

	SC500_DEBUG( "CH02 RECORD MODE = %d", pRecordMode[ 1 ] );

	SC500_DEBUG( "CH03 RECORD MODE = %d", pRecordMode[ 2 ] );

	SC500_DEBUG( "CH04 RECORD MODE = %d", pRecordMode[ 3 ] );

	return TRUE;
}

BOOL CSetupDialog::GetBitRateParameters( ULONG * pBitRate )
{
	if( pBitRate == NULL ) { return FALSE; }

	UpdateData( TRUE );

	for( ULONG i = 0 ; i < 4 ; i++ ) {

		ULONG j = 0;

		if( i ==  0 ) { j = m_comboBitRate01.GetCurSel(); }

		if( i ==  1 ) { j = m_comboBitRate02.GetCurSel(); }
 
		if( i ==  2 ) { j = m_comboBitRate03.GetCurSel(); }

		if( i ==  3 ) { j = m_comboBitRate04.GetCurSel(); }

		if( j ==  0 ) { pBitRate[ i ] = (ULONG)(INT)(12.00 * 1024 * 1024); }

		if( j ==  1 ) { pBitRate[ i ] = (ULONG)(INT)(10.00 * 1024 * 1024); }

		if( j ==  2 ) { pBitRate[ i ] = (ULONG)(INT)( 8.00 * 1024 * 1024); }

		if( j ==  3 ) { pBitRate[ i ] = (ULONG)(INT)( 6.00 * 1024 * 1024); }

		if( j ==  4 ) { pBitRate[ i ] = (ULONG)(INT)( 4.00 * 1024 * 1024); }

		if( j ==  5 ) { pBitRate[ i ] = (ULONG)(INT)( 3.00 * 1024 * 1024); }

		if( j ==  6 ) { pBitRate[ i ] = (ULONG)(INT)( 2.00 * 1024 * 1024); }

		if( j ==  7 ) { pBitRate[ i ] = (ULONG)(INT)( 1.50 * 1024 * 1024); }

		if( j ==  8 ) { pBitRate[ i ] = (ULONG)(INT)( 1.00 * 1024 * 1024); }

		if( j ==  9 ) { pBitRate[ i ] = (ULONG)(INT)( 0.75 * 1024 * 1024); }

		if( j == 10 ) { pBitRate[ i ] = (ULONG)(INT)( 0.50 * 1024 * 1024); }

		if( j == 11 ) { pBitRate[ i ] = (ULONG)(INT)( 0.25 * 1024 * 1024); }
	}
	SC500_DEBUG( "CH01 BIT RATE = %d", pBitRate[ 0 ] );

	SC500_DEBUG( "CH02 BIT RATE = %d", pBitRate[ 1 ] );

	SC500_DEBUG( "CH03 BIT RATE = %d", pBitRate[ 2 ] );

	SC500_DEBUG( "CH04 BIT RATE = %d", pBitRate[ 3 ] );

	return TRUE;
}

BOOL CSetupDialog::GetQualityParameters( ULONG * pQuality )
{
	if( pQuality == NULL ) { return FALSE; }

	UpdateData( TRUE );

	for( ULONG i = 0 ; i < 4 ; i++ ) {

		ULONG j = 0;

		if( i ==  0 ) { j = m_comboQuality01.GetCurSel(); }

		if( i ==  1 ) { j = m_comboQuality02.GetCurSel(); }

		if( i ==  2 ) { j = m_comboQuality03.GetCurSel(); }

		if( i ==  3 ) { j = m_comboQuality04.GetCurSel(); }

		if( j ==  0 ) { pQuality[ i ] = 10000; }

		if( j ==  1 ) { pQuality[ i ] =  9500; }

		if( j ==  2 ) { pQuality[ i ] =  9000; }

		if( j ==  3 ) { pQuality[ i ] =  8500; }

		if( j ==  4 ) { pQuality[ i ] =  8000; }

		if( j ==  5 ) { pQuality[ i ] =  7500; }

		if( j ==  6 ) { pQuality[ i ] =  7000; }

		if( j ==  7 ) { pQuality[ i ] =  6500; }

		if( j ==  8 ) { pQuality[ i ] =  6000; }

		if( j ==  9 ) { pQuality[ i ] =  5500; }

		if( j == 10 ) { pQuality[ i ] =  5000; }

		if( j == 11 ) { pQuality[ i ] =  4500; }

		if( j == 12 ) { pQuality[ i ] =  4000; }

		if( j == 13 ) { pQuality[ i ] =  3500; }

		if( j == 14 ) { pQuality[ i ] =  3000; }

		if( j == 15 ) { pQuality[ i ] =  2500; }

		if( j == 16 ) { pQuality[ i ] =  2000; }

		if( j == 17 ) { pQuality[ i ] =  1500; }

		if( j == 18 ) { pQuality[ i ] =  1000; }

		if( j == 19 ) { pQuality[ i ] =   500; }

		if( j == 20 ) { pQuality[ i ] =     0; }
	}
	SC500_DEBUG( "CH01 QUALITY = %d", pQuality[ 0 ] );

	SC500_DEBUG( "CH02 QUALITY = %d", pQuality[ 1 ] );

	SC500_DEBUG( "CH03 QUALITY = %d", pQuality[ 2 ] );

	SC500_DEBUG( "CH04 QUALITY = %d", pQuality[ 3 ] );

	return TRUE;
}

BOOL CSetupDialog::GetGOPParameters( ULONG * pGOP )
{
	if( pGOP == NULL ) { return FALSE; }

	UpdateData( TRUE );

	pGOP[ 0 ] = m_comboGOP01.GetCurSel() + 1;

	pGOP[ 1 ] = m_comboGOP02.GetCurSel() + 1;

	pGOP[ 2 ] = m_comboGOP03.GetCurSel() + 1;

	pGOP[ 3 ] = m_comboGOP04.GetCurSel() + 1;

	SC500_DEBUG( "CH01 GOP = %d", pGOP[ 0 ] );

	SC500_DEBUG( "CH02 GOP = %d", pGOP[ 1 ] );

	SC500_DEBUG( "CH03 GOP = %d", pGOP[ 2 ] );

	SC500_DEBUG( "CH04 GOP = %d", pGOP[ 3 ] );

	return TRUE;
}

void CSetupDialog::OnButtonPropertyCh01() 
{
	// TODO: Add your control notification handler code here
	
	CSC500Dlg * pParent = (CSC500Dlg *)(GetParent());

	CPropertyDialog dlgProperty;

	dlgProperty.m_hDev = pParent->m_hVideoDev[ 0 ];

	dlgProperty.DoModal();
}

void CSetupDialog::OnButtonPropertyCh02() 
{
	// TODO: Add your control notification handler code here
	
	CSC500Dlg * pParent = (CSC500Dlg *)(GetParent());

	CPropertyDialog dlgProperty;

	dlgProperty.m_hDev = pParent->m_hVideoDev[ 1 ];

	dlgProperty.DoModal();	
}

void CSetupDialog::OnButtonPropertyCh03() 
{
	// TODO: Add your control notification handler code here
	
	CSC500Dlg * pParent = (CSC500Dlg *)(GetParent());

	CPropertyDialog dlgProperty;

	dlgProperty.m_hDev = pParent->m_hVideoDev[ 2 ];

	dlgProperty.DoModal();	
}

void CSetupDialog::OnButtonPropertyCh04() 
{
	// TODO: Add your control notification handler code here
	
	CSC500Dlg * pParent = (CSC500Dlg *)(GetParent());

	CPropertyDialog dlgProperty;

	dlgProperty.m_hDev = pParent->m_hVideoDev[ 3 ];

	dlgProperty.DoModal();	
}

BOOL CSetupDialog::GetRecordPathParameters( CHAR * pszRecordPath )
{
	if( pszRecordPath == NULL ) { return FALSE; }

	sprintf( pszRecordPath, "%C:\\SC500\\", 'C' + m_nLargestAvailableDiskNumber );

	return TRUE;
}
